// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/service_manager/public/interfaces/interface_provider.mojom-shared.h"
#include <string>
#include <vector>
#include "services/service_manager/public/interfaces/interfaces_export.h"


namespace service_manager {
namespace mojom {
class InterfaceProvider;
using InterfaceProviderPtr = mojo::InterfacePtr<InterfaceProvider>;
using InterfaceProviderPtrInfo = mojo::InterfacePtrInfo<InterfaceProvider>;
using ThreadSafeInterfaceProviderPtr =
    mojo::ThreadSafeInterfacePtr<InterfaceProvider>;
using InterfaceProviderRequest = mojo::InterfaceRequest<InterfaceProvider>;
using InterfaceProviderAssociatedPtr =
    mojo::AssociatedInterfacePtr<InterfaceProvider>;
using ThreadSafeInterfaceProviderAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<InterfaceProvider>;
using InterfaceProviderAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<InterfaceProvider>;
using InterfaceProviderAssociatedRequest =
    mojo::AssociatedInterfaceRequest<InterfaceProvider>;


class InterfaceProviderProxy;

template <typename ImplRefTraits>
class InterfaceProviderStub;

class InterfaceProviderRequestValidator;

class SERVICE_MANAGER_MOJOM_EXPORT InterfaceProvider
    : public InterfaceProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = InterfaceProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = InterfaceProviderStub<ImplRefTraits>;

  using RequestValidator_ = InterfaceProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetInterfaceMinVersion = 0,
  };
  virtual ~InterfaceProvider() {}

  virtual void GetInterface(const std::string& interface_name, mojo::ScopedMessagePipeHandle pipe) = 0;
};
class SERVICE_MANAGER_MOJOM_EXPORT InterfaceProviderInterceptorForTesting : public InterfaceProvider {
  virtual InterfaceProvider* GetForwardingInterface() = 0;
  void GetInterface(const std::string& interface_name, mojo::ScopedMessagePipeHandle pipe);
};

class SERVICE_MANAGER_MOJOM_EXPORT InterfaceProviderProxy
    : public InterfaceProvider {
 public:
  explicit InterfaceProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  void GetInterface(const std::string& interface_name, mojo::ScopedMessagePipeHandle pipe) override;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class SERVICE_MANAGER_MOJOM_EXPORT InterfaceProviderStubDispatch {
 public:
  static bool Accept(InterfaceProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      InterfaceProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<InterfaceProvider>>
class InterfaceProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  InterfaceProviderStub() {}
  ~InterfaceProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InterfaceProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InterfaceProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class SERVICE_MANAGER_MOJOM_EXPORT InterfaceProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace service_manager

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_MOJOM_H_