// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_SPEC_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_SPEC_MOJOM_SHARED_INTERNAL_H_

#include <stdint.h>

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/cpp/bindings/lib/native_struct_data.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "services/service_manager/public/interfaces/interfaces_shared_export.h"

namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace service_manager {
namespace mojom {
namespace internal {
class InterfaceSet_Data;
class CapabilitySet_Data;
class InterfaceProviderSpec_Data;

#pragma pack(push, 1)
class SERVICE_MANAGER_MOJOM_SHARED_EXPORT InterfaceSet_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(InterfaceSet_Data));
      new (data()) InterfaceSet_Data();
    }

    bool is_null() const { return !buffer_; }
    InterfaceSet_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<InterfaceSet_Data>(index_);
    }
    InterfaceSet_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> interfaces;

 private:
  InterfaceSet_Data();
  ~InterfaceSet_Data() = delete;
};
static_assert(sizeof(InterfaceSet_Data) == 16,
              "Bad sizeof(InterfaceSet_Data)");
class SERVICE_MANAGER_MOJOM_SHARED_EXPORT CapabilitySet_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(CapabilitySet_Data));
      new (data()) CapabilitySet_Data();
    }

    bool is_null() const { return !buffer_; }
    CapabilitySet_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<CapabilitySet_Data>(index_);
    }
    CapabilitySet_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> capabilities;

 private:
  CapabilitySet_Data();
  ~CapabilitySet_Data() = delete;
};
static_assert(sizeof(CapabilitySet_Data) == 16,
              "Bad sizeof(CapabilitySet_Data)");
class SERVICE_MANAGER_MOJOM_SHARED_EXPORT InterfaceProviderSpec_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(InterfaceProviderSpec_Data));
      new (data()) InterfaceProviderSpec_Data();
    }

    bool is_null() const { return !buffer_; }
    InterfaceProviderSpec_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<InterfaceProviderSpec_Data>(index_);
    }
    InterfaceProviderSpec_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<internal::InterfaceSet_Data>>> provides;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<internal::CapabilitySet_Data>>> requires;

 private:
  InterfaceProviderSpec_Data();
  ~InterfaceProviderSpec_Data() = delete;
};
static_assert(sizeof(InterfaceProviderSpec_Data) == 24,
              "Bad sizeof(InterfaceProviderSpec_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace service_manager

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_SPEC_MOJOM_SHARED_INTERNAL_H_