// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_SPEC_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_SPEC_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/service_manager/public/interfaces/interface_provider_spec.mojom-shared.h"
#include <string>
#include <vector>
#include "services/service_manager/public/cpp/interface_provider_spec.h"
#include "services/service_manager/public/interfaces/interfaces_export.h"


namespace service_manager {
namespace mojom {
SERVICE_MANAGER_MOJOM_EXPORT extern const char kServiceManager_ConnectorSpec[];
class InterfaceSet;
using InterfaceSetPtr = mojo::StructPtr<InterfaceSet>;

class CapabilitySet;
using CapabilitySetPtr = mojo::StructPtr<CapabilitySet>;

class InterfaceProviderSpec;
using InterfaceProviderSpecPtr = mojo::StructPtr<InterfaceProviderSpec>;








class SERVICE_MANAGER_MOJOM_EXPORT InterfaceSet {
 public:
  using DataView = InterfaceSetDataView;
  using Data_ = internal::InterfaceSet_Data;

  template <typename... Args>
  static InterfaceSetPtr New(Args&&... args) {
    return InterfaceSetPtr(
        base::in_place,
        std::forward<Args>(args)...);
  }

  template <typename U>
  static InterfaceSetPtr From(const U& u) {
    return mojo::TypeConverter<InterfaceSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InterfaceSet>::Convert(*this);
  }


  InterfaceSet();

  explicit InterfaceSet(
      const std::vector<std::string>& interfaces);

  ~InterfaceSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InterfaceSetPtr>
  InterfaceSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, InterfaceSet>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::StructSerializeImpl<
        InterfaceSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::StructSerializeAsMessageImpl<
        InterfaceSet::DataView>(input);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::StructDeserializeImpl<InterfaceSet::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return InterfaceSet::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::StructDeserializeImpl<InterfaceSet::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  std::vector<std::string> interfaces;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};


class SERVICE_MANAGER_MOJOM_EXPORT CapabilitySet {
 public:
  using DataView = CapabilitySetDataView;
  using Data_ = internal::CapabilitySet_Data;

  template <typename... Args>
  static CapabilitySetPtr New(Args&&... args) {
    return CapabilitySetPtr(
        base::in_place,
        std::forward<Args>(args)...);
  }

  template <typename U>
  static CapabilitySetPtr From(const U& u) {
    return mojo::TypeConverter<CapabilitySetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CapabilitySet>::Convert(*this);
  }


  CapabilitySet();

  explicit CapabilitySet(
      const std::vector<std::string>& capabilities);

  ~CapabilitySet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CapabilitySetPtr>
  CapabilitySetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CapabilitySet>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::StructSerializeImpl<
        CapabilitySet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::StructSerializeAsMessageImpl<
        CapabilitySet::DataView>(input);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::StructDeserializeImpl<CapabilitySet::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CapabilitySet::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::StructDeserializeImpl<CapabilitySet::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  std::vector<std::string> capabilities;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};


class SERVICE_MANAGER_MOJOM_EXPORT InterfaceProviderSpec {
 public:
  using DataView = InterfaceProviderSpecDataView;
  using Data_ = internal::InterfaceProviderSpec_Data;

  template <typename... Args>
  static InterfaceProviderSpecPtr New(Args&&... args) {
    return InterfaceProviderSpecPtr(
        base::in_place,
        std::forward<Args>(args)...);
  }

  template <typename U>
  static InterfaceProviderSpecPtr From(const U& u) {
    return mojo::TypeConverter<InterfaceProviderSpecPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InterfaceProviderSpec>::Convert(*this);
  }


  InterfaceProviderSpec();

  InterfaceProviderSpec(
      const std::unordered_map<std::string, ::service_manager::InterfaceSet>& provides,
      const std::unordered_map<std::string, ::service_manager::CapabilitySet>& requires);

  ~InterfaceProviderSpec();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InterfaceProviderSpecPtr>
  InterfaceProviderSpecPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, InterfaceProviderSpec>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::StructSerializeImpl<
        InterfaceProviderSpec::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::StructSerializeAsMessageImpl<
        InterfaceProviderSpec::DataView>(input);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::StructDeserializeImpl<InterfaceProviderSpec::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return InterfaceProviderSpec::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::StructDeserializeImpl<InterfaceProviderSpec::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  std::unordered_map<std::string, ::service_manager::InterfaceSet> provides;
  std::unordered_map<std::string, ::service_manager::CapabilitySet> requires;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

template <typename StructPtrType>
InterfaceSetPtr InterfaceSet::Clone() const {
  return New(
      mojo::Clone(interfaces)
  );
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, InterfaceSet>::value>::type*>
bool InterfaceSet::Equals(const T& other) const {
  if (!mojo::Equals(this->interfaces, other.interfaces))
    return false;
  return true;
}
template <typename StructPtrType>
CapabilitySetPtr CapabilitySet::Clone() const {
  return New(
      mojo::Clone(capabilities)
  );
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CapabilitySet>::value>::type*>
bool CapabilitySet::Equals(const T& other) const {
  if (!mojo::Equals(this->capabilities, other.capabilities))
    return false;
  return true;
}
template <typename StructPtrType>
InterfaceProviderSpecPtr InterfaceProviderSpec::Clone() const {
  return New(
      mojo::Clone(provides),
      mojo::Clone(requires)
  );
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, InterfaceProviderSpec>::value>::type*>
bool InterfaceProviderSpec::Equals(const T& other) const {
  if (!mojo::Equals(this->provides, other.provides))
    return false;
  if (!mojo::Equals(this->requires, other.requires))
    return false;
  return true;
}


}  // namespace mojom
}  // namespace service_manager

namespace mojo {


template <>
struct SERVICE_MANAGER_MOJOM_EXPORT StructTraits<::service_manager::mojom::InterfaceSet::DataView,
                                         ::service_manager::mojom::InterfaceSetPtr> {
  static bool IsNull(const ::service_manager::mojom::InterfaceSetPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::InterfaceSetPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::InterfaceSet::interfaces)& interfaces(
      const ::service_manager::mojom::InterfaceSetPtr& input) {
    return input->interfaces;
  }

  static bool Read(::service_manager::mojom::InterfaceSet::DataView input, ::service_manager::mojom::InterfaceSetPtr* output);
};


template <>
struct SERVICE_MANAGER_MOJOM_EXPORT StructTraits<::service_manager::mojom::CapabilitySet::DataView,
                                         ::service_manager::mojom::CapabilitySetPtr> {
  static bool IsNull(const ::service_manager::mojom::CapabilitySetPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::CapabilitySetPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::CapabilitySet::capabilities)& capabilities(
      const ::service_manager::mojom::CapabilitySetPtr& input) {
    return input->capabilities;
  }

  static bool Read(::service_manager::mojom::CapabilitySet::DataView input, ::service_manager::mojom::CapabilitySetPtr* output);
};


template <>
struct SERVICE_MANAGER_MOJOM_EXPORT StructTraits<::service_manager::mojom::InterfaceProviderSpec::DataView,
                                         ::service_manager::mojom::InterfaceProviderSpecPtr> {
  static bool IsNull(const ::service_manager::mojom::InterfaceProviderSpecPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::InterfaceProviderSpecPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::InterfaceProviderSpec::provides)& provides(
      const ::service_manager::mojom::InterfaceProviderSpecPtr& input) {
    return input->provides;
  }

  static const decltype(::service_manager::mojom::InterfaceProviderSpec::requires)& requires(
      const ::service_manager::mojom::InterfaceProviderSpecPtr& input) {
    return input->requires;
  }

  static bool Read(::service_manager::mojom::InterfaceProviderSpec::DataView input, ::service_manager::mojom::InterfaceProviderSpecPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_INTERFACE_PROVIDER_SPEC_MOJOM_H_