// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MOJOM_SHARED_INTERNAL_H_

#include <stdint.h>

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/cpp/bindings/lib/native_struct_data.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "services/service_manager/public/interfaces/connector.mojom-shared-internal.h"
#include "services/service_manager/public/interfaces/interface_provider.mojom-shared-internal.h"
#include "services/service_manager/public/interfaces/interface_provider_spec.mojom-shared-internal.h"
#include "services/service_manager/public/interfaces/service_control.mojom-shared-internal.h"
#include "services/service_manager/public/interfaces/interfaces_shared_export.h"

namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace service_manager {
namespace mojom {
namespace internal {
class BindSourceInfo_Data;

#pragma pack(push, 1)
class SERVICE_MANAGER_MOJOM_SHARED_EXPORT BindSourceInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(BindSourceInfo_Data));
      new (data()) BindSourceInfo_Data();
    }

    bool is_null() const { return !buffer_; }
    BindSourceInfo_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<BindSourceInfo_Data>(index_);
    }
    BindSourceInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::service_manager::mojom::internal::Identity_Data> identity;
  mojo::internal::Pointer<::service_manager::mojom::internal::CapabilitySet_Data> required_capabilities;

 private:
  BindSourceInfo_Data();
  ~BindSourceInfo_Data() = delete;
};
static_assert(sizeof(BindSourceInfo_Data) == 24,
              "Bad sizeof(BindSourceInfo_Data)");
constexpr uint32_t kService_OnStart_Name = 0;
class SERVICE_MANAGER_MOJOM_SHARED_EXPORT Service_OnStart_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(Service_OnStart_Params_Data));
      new (data()) Service_OnStart_Params_Data();
    }

    bool is_null() const { return !buffer_; }
    Service_OnStart_Params_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<Service_OnStart_Params_Data>(index_);
    }
    Service_OnStart_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::service_manager::mojom::internal::Identity_Data> identity;

 private:
  Service_OnStart_Params_Data();
  ~Service_OnStart_Params_Data() = delete;
};
static_assert(sizeof(Service_OnStart_Params_Data) == 16,
              "Bad sizeof(Service_OnStart_Params_Data)");
class SERVICE_MANAGER_MOJOM_SHARED_EXPORT Service_OnStart_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(Service_OnStart_ResponseParams_Data));
      new (data()) Service_OnStart_ResponseParams_Data();
    }

    bool is_null() const { return !buffer_; }
    Service_OnStart_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<Service_OnStart_ResponseParams_Data>(index_);
    }
    Service_OnStart_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data connector_request;
  mojo::internal::AssociatedEndpointHandle_Data control_request;

 private:
  Service_OnStart_ResponseParams_Data();
  ~Service_OnStart_ResponseParams_Data() = delete;
};
static_assert(sizeof(Service_OnStart_ResponseParams_Data) == 16,
              "Bad sizeof(Service_OnStart_ResponseParams_Data)");
constexpr uint32_t kService_OnBindInterface_Name = 1;
class SERVICE_MANAGER_MOJOM_SHARED_EXPORT Service_OnBindInterface_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(Service_OnBindInterface_Params_Data));
      new (data()) Service_OnBindInterface_Params_Data();
    }

    bool is_null() const { return !buffer_; }
    Service_OnBindInterface_Params_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<Service_OnBindInterface_Params_Data>(index_);
    }
    Service_OnBindInterface_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::BindSourceInfo_Data> source;
  mojo::internal::Pointer<mojo::internal::String_Data> interface_name;
  mojo::internal::Handle_Data interface_pipe;
  uint8_t padfinal_[4];

 private:
  Service_OnBindInterface_Params_Data();
  ~Service_OnBindInterface_Params_Data() = delete;
};
static_assert(sizeof(Service_OnBindInterface_Params_Data) == 32,
              "Bad sizeof(Service_OnBindInterface_Params_Data)");
class SERVICE_MANAGER_MOJOM_SHARED_EXPORT Service_OnBindInterface_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(Service_OnBindInterface_ResponseParams_Data));
      new (data()) Service_OnBindInterface_ResponseParams_Data();
    }

    bool is_null() const { return !buffer_; }
    Service_OnBindInterface_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<Service_OnBindInterface_ResponseParams_Data>(index_);
    }
    Service_OnBindInterface_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  Service_OnBindInterface_ResponseParams_Data();
  ~Service_OnBindInterface_ResponseParams_Data() = delete;
};
static_assert(sizeof(Service_OnBindInterface_ResponseParams_Data) == 8,
              "Bad sizeof(Service_OnBindInterface_ResponseParams_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace service_manager

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MOJOM_SHARED_INTERNAL_H_