// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_FACTORY_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/service_manager/public/interfaces/service_factory.mojom-shared.h"
#include "services/service_manager/public/interfaces/service.mojom.h"
#include <string>
#include <vector>
#include "services/service_manager/public/interfaces/interfaces_export.h"


namespace service_manager {
namespace mojom {
class ServiceFactory;
using ServiceFactoryPtr = mojo::InterfacePtr<ServiceFactory>;
using ServiceFactoryPtrInfo = mojo::InterfacePtrInfo<ServiceFactory>;
using ThreadSafeServiceFactoryPtr =
    mojo::ThreadSafeInterfacePtr<ServiceFactory>;
using ServiceFactoryRequest = mojo::InterfaceRequest<ServiceFactory>;
using ServiceFactoryAssociatedPtr =
    mojo::AssociatedInterfacePtr<ServiceFactory>;
using ThreadSafeServiceFactoryAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<ServiceFactory>;
using ServiceFactoryAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<ServiceFactory>;
using ServiceFactoryAssociatedRequest =
    mojo::AssociatedInterfaceRequest<ServiceFactory>;


class ServiceFactoryProxy;

template <typename ImplRefTraits>
class ServiceFactoryStub;

class ServiceFactoryRequestValidator;

class SERVICE_MANAGER_MOJOM_EXPORT ServiceFactory
    : public ServiceFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = ServiceFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ServiceFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateServiceMinVersion = 0,
  };
  virtual ~ServiceFactory() {}

  virtual void CreateService(::service_manager::mojom::ServiceRequest service, const std::string& name) = 0;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceFactoryInterceptorForTesting : public ServiceFactory {
  virtual ServiceFactory* GetForwardingInterface() = 0;
  void CreateService(::service_manager::mojom::ServiceRequest service, const std::string& name);
};

class SERVICE_MANAGER_MOJOM_EXPORT ServiceFactoryProxy
    : public ServiceFactory {
 public:
  explicit ServiceFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  void CreateService(::service_manager::mojom::ServiceRequest service, const std::string& name) override;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceFactoryStubDispatch {
 public:
  static bool Accept(ServiceFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceFactory>>
class ServiceFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceFactoryStub() {}
  ~ServiceFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace service_manager

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_FACTORY_MOJOM_H_