# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2017-06-21 16:58
from __future__ import unicode_literals

from functools import partial

from django.db import migrations
from django.db import OperationalError

import kolibri.core.fields
import kolibri.utils.time


def convert_datetime_to_datetimetz(apps, schema_editor, model_name=None):
    if model_name:
        Model = apps.get_model("kolibriauth", model_name)
        try:
            # Prevent the non-existence of this table from blowing up test runs
            # Seems to only occur on test runs on Travis, but otherwise works fine
            # Hopefully future migration squashes should prevent this code being
            # called at all for new users
            for model in Model.objects.all():
                model.save()
        except OperationalError:
            pass

class Migration(migrations.Migration):

    dependencies = [
        ('kolibriauth', '0002_auto_20170608_2125'),
    ]

    operations = [
        migrations.AlterField(
            model_name='deviceowner',
            name='date_joined',
            field=kolibri.core.fields.DateTimeTzField(default=kolibri.utils.time.local_now, editable=False, verbose_name='date joined'),
        ),
        migrations.RunPython(partial(convert_datetime_to_datetimetz, model_name="DeviceOwner")),
        migrations.AlterField(
            model_name='facilityuser',
            name='date_joined',
            field=kolibri.core.fields.DateTimeTzField(default=kolibri.utils.time.local_now, editable=False, verbose_name='date joined'),
        ),
        migrations.RunPython(partial(convert_datetime_to_datetimetz, model_name="FacilityUser")),
    ]
