/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_plugin.commands;

import com.nukkitx.protocol.bedrock.data.command.CommandParamType;
import dev.projectearth.genoa_plugin.GenoaPlugin;
import java.util.Optional;
import java.util.UUID;
import org.cloudburstmc.server.command.Command;
import org.cloudburstmc.server.command.CommandSender;
import org.cloudburstmc.server.command.data.CommandData;
import org.cloudburstmc.server.command.data.CommandParameter;
import org.cloudburstmc.server.entity.Entity;
import org.cloudburstmc.server.entity.EntityType;
import org.cloudburstmc.server.level.Location;
import org.cloudburstmc.server.player.IPlayer;
import org.cloudburstmc.server.player.Player;
import org.cloudburstmc.server.registry.EntityRegistry;
import org.cloudburstmc.server.utils.Identifier;

public class SummonCommand
extends Command {
    public SummonCommand() {
        super("summon", CommandData.builder((String)"summon").setDescription("Summon an entity").setUsageMessage("/summon <entity> <player>").setPermissions(new String[]{"genoa.command.summon"}).setParameters((CommandParameter[][])new CommandParameter[][]{{new CommandParameter("id", CommandParamType.STRING, false), new CommandParameter("player", CommandParamType.TARGET, false)}}).build());
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        EntityType entityType = EntityRegistry.get().getEntityType(Identifier.fromString((String)args[0]));
        Optional uuid = sender.getServer().lookupName(args[1]);
        if (uuid.isPresent()) {
            IPlayer player = sender.getServer().getOfflinePlayer((UUID)uuid.get());
            if (entityType == null) {
                return false;
            }
            if (player instanceof Player) {
                Location playerLocation;
                Player actualPlayer = (Player)player;
                Location pos = playerLocation = actualPlayer.getLocation();
                Entity ent = EntityRegistry.get().newEntity(entityType, pos);
                GenoaPlugin.get().getLogger().info("Spawning " + ent.getName() + " at " + pos.getPosition());
                ent.setPosition(pos.getPosition());
                ent.spawnToAll();
                return true;
            }
        }
        return false;
    }
}

