/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_plugin.commands;

import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import dev.projectearth.genoa_plugin.GenoaPlugin;
import dev.projectearth.genoa_plugin.entities.GenoaEntityTypes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.cloudburstmc.server.command.Command;
import org.cloudburstmc.server.command.CommandSender;
import org.cloudburstmc.server.command.data.CommandData;
import org.cloudburstmc.server.entity.Entity;
import org.cloudburstmc.server.entity.EntityType;
import org.cloudburstmc.server.level.Location;
import org.cloudburstmc.server.player.Player;
import org.cloudburstmc.server.registry.EntityRegistry;

public class TestEntCommand
extends Command {
    public TestEntCommand() {
        super("testent", CommandData.builder((String)"testent").setDescription("Test entites").setUsageMessage("/testent").setPermissions(new String[]{"genoa.command.testent"}).build());
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Field[] fields = GenoaEntityTypes.class.getFields();
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (Field field : fields) {
            if (!field.getType().isAssignableFrom(EntityType.class)) continue;
            try {
                entityTypes.add((EntityType)field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        Location basePos = ((Player)sender).getLocation();
        int i = 0;
        for (EntityType entityType : entityTypes) {
            Location entPos = basePos.add((double)(i % 10 * 5), 0.0, Math.floor((float)i / 10.0f) * 5.0);
            Entity ent = EntityRegistry.get().newEntity(entityType, entPos);
            GenoaPlugin.get().getLogger().info("Spawning " + ent.getName() + " at " + entPos.getPosition());
            ent.setPosition(entPos.getPosition());
            ent.setNameTag(ent.getName());
            ent.getData().setShort(EntityData.AIR_SUPPLY, Short.MAX_VALUE);
            ent.getData().setFlag(EntityFlag.ALWAYS_SHOW_NAME, true);
            ent.spawnToAll();
            ++i;
        }
        return true;
    }
}

