/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_plugin.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nukkitx.math.vector.Vector2f;
import com.nukkitx.math.vector.Vector3i;
import dev.projectearth.genoa_plugin.GenoaPlugin;
import dev.projectearth.genoa_plugin.providers.EntityDataLoader;
import dev.projectearth.genoa_plugin.utils.Buildplate;
import dev.projectearth.genoa_plugin.utils.BuildplateEntity;
import dev.projectearth.genoa_plugin.utils.BuildplateResponse;
import dev.projectearth.genoa_plugin.utils.PaletteBlock;
import dev.projectearth.genoa_plugin.utils.SubChunk;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.cloudburstmc.api.level.gamerule.GameRule;
import org.cloudburstmc.api.level.gamerule.GameRules;
import org.cloudburstmc.server.CloudServer;
import org.cloudburstmc.server.entity.Entity;
import org.cloudburstmc.server.level.LevelData;
import org.cloudburstmc.server.level.chunk.Chunk;
import org.cloudburstmc.server.level.chunk.ChunkBuilder;
import org.cloudburstmc.server.level.chunk.ChunkDataLoader;
import org.cloudburstmc.server.level.chunk.ChunkSection;
import org.cloudburstmc.server.level.provider.LevelProvider;
import org.cloudburstmc.server.registry.CloudGameRuleRegistry;
import org.cloudburstmc.server.utils.Identifier;
import org.cloudburstmc.server.utils.LoadState;

public class JsonLevelProvider
implements LevelProvider {
    public static final Identifier ID = Identifier.from((String)"genoa", (String)"json");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String levelId;
    private final Path levelsPath;
    private final Executor executor;
    private Buildplate buildplate;

    public JsonLevelProvider(String levelId, Path levelsPath, Executor executor) {
        this.levelId = levelId;
        this.levelsPath = levelsPath;
        this.executor = executor;
        GenoaPlugin.get().getLogger().info("Loading json " + levelId + "...");
        try {
            BuildplateResponse buildplateResponse = (BuildplateResponse)OBJECT_MAPPER.readValue(levelsPath.resolve(levelId + ".json").toFile(), BuildplateResponse.class);
            this.buildplate = buildplateResponse.getResult();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getLevelId() {
        return this.levelId;
    }

    public CompletableFuture<Chunk> readChunk(ChunkBuilder chunkBuilder) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkSection[] chunkSections = new ChunkSection[16];
            for (SubChunk subChunk : this.buildplate.getBuildplateData().getModel().getSubChunks()) {
                if (subChunk.getPosition().getX() != chunkBuilder.getX() || subChunk.getPosition().getZ() != chunkBuilder.getZ()) continue;
                ChunkSection chunkSection = new ChunkSection();
                for (int i = 0; i < subChunk.getBlocks().length; ++i) {
                    PaletteBlock block = subChunk.getBlockPalette()[subChunk.getBlocks()[i]];
                    Vector3i pos = JsonLevelProvider.to3D(i);
                    chunkSection.setBlock(pos.getX(), pos.getY(), pos.getZ(), 0, block.getState());
                }
                chunkSections[subChunk.getPosition().getY()] = chunkSection;
            }
            ArrayList<BuildplateEntity> entities = new ArrayList<BuildplateEntity>();
            int rawX = chunkBuilder.getX() * 16;
            int rawZ = chunkBuilder.getZ() * 16;
            if (this.buildplate.getBuildplateData().getModel().getEntities() != null) {
                for (BuildplateEntity entity : this.buildplate.getBuildplateData().getModel().getEntities()) {
                    if (!(entity.getPosition().getX() >= (float)rawX) || !((float)(rawX + 16) > entity.getPosition().getX()) || !(entity.getPosition().getZ() >= (float)rawZ) || !((float)(rawZ + 16) > entity.getPosition().getZ())) continue;
                    entities.add(entity);
                }
            }
            chunkBuilder.dataLoader((ChunkDataLoader)new EntityDataLoader(entities));
            chunkBuilder.sections(chunkSections);
            int[] nArray = new int[512];
            Arrays.fill(nArray, 256);
            chunkBuilder.heightMap(nArray);
            byte[] biomes = new byte[256];
            Arrays.fill(biomes, (byte)0);
            chunkBuilder.biomes(biomes);
            return chunkBuilder.build();
        }, this.executor);
    }

    public CompletableFuture<Void> saveChunk(Chunk chunk) {
        return CompletableFuture.runAsync(() -> {
            for (int subChunkY = 0; subChunkY < chunk.getSections().length; ++subChunkY) {
                ChunkSection section = chunk.getSection(subChunkY);
                if (section == null || section.isEmpty()) continue;
                SubChunk subChunk = new SubChunk();
                subChunk.setPosition(Vector3i.from((int)chunk.getX(), (int)subChunkY, (int)chunk.getZ()));
                ArrayList<PaletteBlock> paletteBlocks = new ArrayList<PaletteBlock>();
                int[] blocks = new int[4096];
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            PaletteBlock block = PaletteBlock.from(section.getBlock(x, y, z, 0));
                            int stateIndex = paletteBlocks.indexOf(block);
                            if (stateIndex == -1) {
                                stateIndex = paletteBlocks.size();
                                paletteBlocks.add(block);
                            }
                            blocks[JsonLevelProvider.from3D((int)x, (int)y, (int)z)] = stateIndex;
                        }
                    }
                }
                subChunk.setBlocks(blocks);
                subChunk.setBlockPalette(paletteBlocks.toArray(new PaletteBlock[0]));
                boolean replaced = false;
                for (int i = 0; i < this.buildplate.getBuildplateData().getModel().getSubChunks().length; ++i) {
                    SubChunk tmpSubChunk = this.buildplate.getBuildplateData().getModel().getSubChunks()[i];
                    if (!tmpSubChunk.getPosition().equals((Object)subChunk.getPosition())) continue;
                    this.buildplate.getBuildplateData().getModel().getSubChunks()[i] = subChunk;
                    replaced = true;
                    break;
                }
                if (replaced) continue;
                SubChunk[] newSubChunks = new SubChunk[this.buildplate.getBuildplateData().getModel().getSubChunks().length + 1];
                System.arraycopy(this.buildplate.getBuildplateData().getModel().getSubChunks(), 0, newSubChunks, 0, this.buildplate.getBuildplateData().getModel().getSubChunks().length);
                newSubChunks[newSubChunks.length - 1] = subChunk;
                this.buildplate.getBuildplateData().getModel().setSubChunks(newSubChunks);
            }
            System.out.println("Saved chunk: " + chunk.getX() + ", " + chunk.getZ());
        }, this.executor);
    }

    public CompletableFuture<Void> forEachChunk(ChunkBuilder.Factory factory, BiConsumer<Chunk, Throwable> consumer) {
        return CompletableFuture.runAsync(() -> {}, this.executor);
    }

    public CompletableFuture<LoadState> loadLevelData(LevelData levelData) {
        return CompletableFuture.supplyAsync(() -> {
            levelData.getGameRules().putAll(CloudGameRuleRegistry.get().getDefaultRules());
            levelData.getGameRules().put((GameRule)GameRules.DO_DAYLIGHT_CYCLE, (Comparable)Boolean.valueOf(false));
            levelData.getGameRules().put((GameRule)GameRules.DO_WEATHER_CYCLE, (Comparable)Boolean.valueOf(false));
            levelData.setTime(this.buildplate.getBuildplateData().getModel().isNight() ? 18000L : 6000L);
            levelData.setSpawn(this.buildplate.getBuildplateData().getOffset());
            return LoadState.LOADED;
        }, this.executor);
    }

    public CompletableFuture<Void> saveLevelData(LevelData levelData) {
        return CompletableFuture.runAsync(() -> {});
    }

    public void close() throws IOException {
        ArrayList<BuildplateEntity> entities = new ArrayList<BuildplateEntity>();
        for (Entity entity : CloudServer.getInstance().getLevel(this.levelId).getEntities()) {
            BuildplateEntity buildplateEntity = new BuildplateEntity();
            buildplateEntity.setName(entity.getType().getIdentifier().toString());
            buildplateEntity.setPosition(entity.getPosition());
            buildplateEntity.setShadowPosition(entity.getPosition());
            buildplateEntity.setShadowSize(entity.getWidth());
            buildplateEntity.setRotation(Vector2f.from((float)entity.getYaw(), (float)entity.getPitch()));
            entities.add(buildplateEntity);
        }
        BuildplateResponse response = new BuildplateResponse();
        response.setResult(this.buildplate);
        OBJECT_MAPPER.writeValue(this.levelsPath.resolve(this.levelId + ".json").toFile(), (Object)response);
        System.out.println("Saved " + this.levelId + ".json");
    }

    private static Vector3i to3D(int index) {
        int z = index % 16;
        int y = (int)Math.floor((float)index / 16.0f % 16.0f);
        int x = (int)Math.floor((float)index / 256.0f);
        return Vector3i.from((int)x, (int)y, (int)z);
    }

    private static int from3D(int x, int y, int z) {
        return z + y * 16 + x * 256;
    }
}

