/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_plugin;

import com.google.inject.Inject;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.genoa.packet.GenoaItemParticlePacket;
import dev.projectearth.genoa_plugin.commands.BuildplateCommand;
import dev.projectearth.genoa_plugin.commands.SummonCommand;
import dev.projectearth.genoa_plugin.commands.TestEntCommand;
import dev.projectearth.genoa_plugin.entities.GenoaEntityLoader;
import dev.projectearth.genoa_plugin.generators.VoidGenerator;
import dev.projectearth.genoa_plugin.providers.JsonLevelProvider;
import dev.projectearth.genoa_plugin.providers.JsonLevelProviderFactory;
import dev.projectearth.genoa_plugin.utils.Buildplate;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.cloudburstmc.api.plugin.Plugin;
import org.cloudburstmc.api.plugin.PluginContainer;
import org.cloudburstmc.api.plugin.PluginDescription;
import org.cloudburstmc.server.CloudServer;
import org.cloudburstmc.server.command.Command;
import org.cloudburstmc.server.event.Listener;
import org.cloudburstmc.server.event.block.BlockBreakEvent;
import org.cloudburstmc.server.event.player.PlayerJoinEvent;
import org.cloudburstmc.server.event.server.ServerInitializationEvent;
import org.cloudburstmc.server.level.provider.LevelProviderFactory;
import org.cloudburstmc.server.registry.CommandRegistry;
import org.cloudburstmc.server.registry.GeneratorRegistry;
import org.cloudburstmc.server.registry.StorageRegistry;
import org.slf4j.Logger;

@Plugin(id="GenoaPlugin", name="Genoa Plugin", version="1.0.0")
public class GenoaPlugin
implements PluginContainer {
    private static GenoaPlugin INSTANCE;
    private final Logger logger;
    private final PluginDescription description;
    private final Path dataDirectory;
    private final CloudServer server;
    private final Map<String, Buildplate> buildplates = new HashMap<String, Buildplate>();

    @Inject
    private GenoaPlugin(Logger logger, PluginDescription description, Path dataDirectory) {
        this.logger = logger;
        this.description = description;
        this.dataDirectory = dataDirectory;
        this.server = CloudServer.getInstance();
        INSTANCE = this;
    }

    @Listener
    public void onInitialization(ServerInitializationEvent event) {
        this.logger.info("Genoa plugin loading...");
        GeneratorRegistry.get().register(VoidGenerator.ID, VoidGenerator::new, 0);
        StorageRegistry.get().register(JsonLevelProvider.ID, (LevelProviderFactory)JsonLevelProviderFactory.INSTANCE, 0);
        CommandRegistry.get().register((PluginContainer)this, (Command)new BuildplateCommand());
        CommandRegistry.get().register((PluginContainer)this, (Command)new TestEntCommand());
        CommandRegistry.get().register((PluginContainer)this, (Command)new SummonCommand());
        GenoaEntityLoader.load();
        this.logger.info("Genoa plugin has loaded!");
    }

    @Listener
    public void onBlockBreak(BlockBreakEvent event) {
        GenoaItemParticlePacket packet = new GenoaItemParticlePacket();
        packet.setPosition(event.getBlock().getPosition().toFloat().add(0.5, 0.5, 0.5));
        packet.setParticleId(5);
        packet.setDimensionId(1);
        packet.setUniqueEntityId(event.getPlayer().getUniqueId());
        event.getPlayer().sendPacket((BedrockPacket)packet);
    }

    @Listener
    public void onJoin(PlayerJoinEvent event) {
    }

    public static GenoaPlugin get() {
        return INSTANCE;
    }

    public Object getPlugin() {
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PluginDescription getDescription() {
        return this.description;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public Map<String, Buildplate> getBuildplates() {
        return this.buildplates;
    }
}

