/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_plugin.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.projectearth.genoa_plugin.GenoaPlugin;
import dev.projectearth.genoa_plugin.generators.VoidGenerator;
import dev.projectearth.genoa_plugin.providers.JsonLevelProvider;
import dev.projectearth.genoa_plugin.utils.BuildplateResponse;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.cloudburstmc.server.CloudServer;
import org.cloudburstmc.server.level.Level;

public class BuildplateLoader {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Level registerBuildplate(String buildplateId) {
        try {
            GenoaPlugin.get().getLogger().info("Downloading buildplate " + buildplateId + "...");
            File buildplateFile = new File(CloudServer.getInstance().getFilePath() + "/worlds/" + buildplateId + ".json");
            if (!buildplateFile.exists()) {
                return null;
            }
            GenoaPlugin.get().getLogger().info("Loading buildplate " + buildplateId + "...");
            BuildplateResponse buildplateResponse = (BuildplateResponse)OBJECT_MAPPER.readValue(buildplateFile, BuildplateResponse.class);
            GenoaPlugin.get().getBuildplates().put(buildplateId, buildplateResponse.getResult());
            GenoaPlugin.get().getLogger().info("Creating level for buildplate " + buildplateId + "...");
            return (Level)CloudServer.getInstance().loadLevel().id(buildplateId).seed(0L).generator(VoidGenerator.ID).storage(JsonLevelProvider.ID).load().get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            GenoaPlugin.get().getLogger().error("Something went wrong loading buildplate '" + buildplateId + "':", (Throwable)e);
            return null;
        }
    }
}

