/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_plugin.utils;

public enum MobColor {
    WHITE(0, 0xF0F0F0),
    ORANGE(1, 16351261),
    MAGENTA(2, 13061821),
    LIGHT_BLUE(3, 3847130),
    YELLOW(4, 16701501),
    LIME(5, 8439583),
    PINK(6, 15961002),
    GRAY(7, 4673362),
    LIGHT_GRAY(8, 0x9D9D97),
    CYAN(9, 1481884),
    PURPLE(10, 8991416),
    BLUE(11, 3949738),
    BROWN(12, 8606770),
    GREEN(13, 6192150),
    RED(14, 11546150),
    BLACK(15, 0x1D1D21);

    private static final MobColor[] VALUES;
    private byte bedrockID;
    private int colorCode;

    private MobColor(byte bedrockID, int colorCode) {
        this.bedrockID = bedrockID;
        this.colorCode = colorCode;
    }

    public static MobColor fromColorCode(int colorCode) {
        colorCode &= 0xFFFFFF;
        for (MobColor color : VALUES) {
            if (color.colorCode != colorCode) continue;
            return color;
        }
        return WHITE;
    }

    public static MobColor fromBedrockID(int id) {
        for (MobColor color : VALUES) {
            if (color.bedrockID != id) continue;
            return color;
        }
        return WHITE;
    }

    public byte getBedrockID() {
        return this.bedrockID;
    }

    public int getColorCode() {
        return this.colorCode;
    }

    static {
        VALUES = MobColor.values();
    }
}

