/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_plugin.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.cloudburstmc.server.block.BlockState;
import org.cloudburstmc.server.block.util.BlockStateMetaMappings;
import org.cloudburstmc.server.registry.BlockRegistry;
import org.cloudburstmc.server.utils.Identifier;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaletteBlock {
    private int data;
    private String name;
    @JsonIgnore
    private BlockState state;

    public PaletteBlock(String name, int data) {
        this.name = name;
        this.data = data;
    }

    @JsonIgnore
    public BlockState getState() {
        if (this.state == null) {
            this.state = BlockRegistry.get().getBlock(Identifier.fromString((String)this.name), this.data);
        }
        return this.state;
    }

    public static PaletteBlock from(BlockState block) {
        int data = BlockStateMetaMappings.getMetaFromState((BlockState)block);
        if (data == -1) {
            data = 0;
        }
        return new PaletteBlock(block.getId().toString(), data);
    }

    public int getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public PaletteBlock() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaletteBlock)) {
            return false;
        }
        PaletteBlock other = (PaletteBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getData() != other.getData()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BlockState this$state = this.getState();
        BlockState other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaletteBlock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getData();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BlockState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }
}

