/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_allocator_plugin.utils;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.sun.org.apache.xerces.internal.impl.dv.util.HexBin;
import dev.projectearth.genoa_allocator_plugin.GenoaAllocatorPlugin;
import dev.projectearth.genoa_allocator_plugin.utils.AuthStages;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.cloudburstmc.server.CloudServer;
import org.cloudburstmc.server.utils.genoa.GenoaUtils;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;

public class ApiClient
extends WebSocketClient {
    private AuthStages currentStage = AuthStages.NotAuthed;

    public ApiClient(URI serverUri) {
        super(serverUri);
    }

    public ApiClient(URI serverUri, Draft draft) {
        super(serverUri, draft);
    }

    @Override
    public void onOpen(ServerHandshake handshake) {
        GenoaAllocatorPlugin.get().getLogger().info("WebSocket connection established!");
    }

    @Override
    public void onMessage(String message) {
        switch (this.currentStage) {
            case NotAuthed: {
                this.send(this.encodeChallenge(message));
                this.currentStage = AuthStages.AuthStage1;
                break;
            }
            case AuthStage1: {
                if (Boolean.parseBoolean(message)) {
                    this.currentStage = AuthStages.AuthStage2;
                    break;
                }
                GenoaAllocatorPlugin.get().getLogger().error("Core API verification failed!");
                CloudServer.getInstance().shutdown();
                break;
            }
            case AuthStage2: {
                GenoaUtils.setServerApiKey((String)message);
                this.currentStage = AuthStages.Authed;
                break;
            }
            case Authed: {
                new Thread(() -> GenoaAllocatorPlugin.get().onBuildplateLoadRequest(message)).start();
            }
        }
    }

    private String encodeChallenge(String challenge) {
        try {
            String key = Files.lines(Paths.get(GenoaAllocatorPlugin.get().getDataDirectory() + "/key.txt", new String[0])).collect(Collectors.joining());
            byte[] keyBytes = Base64.decode(key);
            Mac HmacSha256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(keyBytes, "HmacSHA256");
            HmacSha256.init(secret_key);
            return HexBin.encode(HmacSha256.doFinal(challenge.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            GenoaAllocatorPlugin.get().getLogger().error("Error while trying to encode Challenge!");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void onError(Exception ex) {
        ex.printStackTrace();
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        System.out.println("Connection closed by " + (remote ? "remote peer" : "us") + " Code: " + code + " Reason: " + reason);
    }
}

