/*
 * Decompiled with CFR 0.152.
 */
package dev.projectearth.genoa_allocator_plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import dev.projectearth.genoa_allocator_plugin.utils.ApiClient;
import dev.projectearth.genoa_allocator_plugin.utils.ServerBuildplateRequest;
import dev.projectearth.genoa_allocator_plugin.utils.ServerInformation;
import dev.projectearth.genoa_allocator_plugin.utils.ServerInstanceInfo;
import dev.projectearth.genoa_allocator_plugin.utils.ServerInstanceRequestInfo;
import dev.projectearth.genoa_plugin.GenoaPlugin;
import dev.projectearth.genoa_plugin.utils.BuildplateLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.cloudburstmc.api.plugin.Plugin;
import org.cloudburstmc.api.plugin.PluginContainer;
import org.cloudburstmc.api.plugin.PluginDescription;
import org.cloudburstmc.server.CloudServer;
import org.cloudburstmc.server.event.Listener;
import org.cloudburstmc.server.event.player.PlayerJoinEvent;
import org.cloudburstmc.server.event.player.PlayerQuitEvent;
import org.cloudburstmc.server.event.server.ServerInitializationEvent;
import org.cloudburstmc.server.level.Location;
import org.cloudburstmc.server.player.Player;
import org.cloudburstmc.server.utils.genoa.GenoaServerCommand;
import org.cloudburstmc.server.utils.genoa.GenoaUtils;
import org.java_websocket.client.WebSocketClient;
import org.slf4j.Logger;

@Plugin(id="GenoaAllocatorPlugin", name="Genoa Allocator Plugin", version="1.0.0")
public class GenoaAllocatorPlugin
implements PluginContainer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static GenoaAllocatorPlugin INSTANCE;
    private final Logger logger;
    private final PluginDescription description;
    private final Path dataDirectory;
    private final CloudServer server;
    private final GenoaPlugin normalPlugin;
    private final Map<String, UUID> playerInstanceMap = new HashMap<String, UUID>();
    private final Map<UUID, UUID> instanceBuildplateMap = new HashMap<UUID, UUID>();
    private WebSocketClient client;

    @Inject
    private GenoaAllocatorPlugin(Logger logger, PluginDescription description, Path dataDirectory) {
        this.logger = logger;
        this.description = description;
        this.dataDirectory = dataDirectory;
        this.server = CloudServer.getInstance();
        if (this.server.getPluginManager().getPlugin("GenoaPlugin").isPresent()) {
            this.normalPlugin = GenoaPlugin.get();
        } else {
            this.normalPlugin = null;
            this.logger.error("The normal Genoa plugin was not found in your cloudburst installation.");
            this.logger.error("Make sure it is installed correctly!");
            this.server.shutdown();
        }
        INSTANCE = this;
    }

    @Listener
    public void onInitialization(ServerInitializationEvent event) {
        this.logger.info("Genoa allocator plugin loading...");
        try {
            this.client = this.startListeningServer();
            this.client.setConnectionLostTimeout(0);
            this.client.connect();
            while (!this.client.isOpen()) {
            }
            this.registerServer();
        }
        catch (Exception e) {
            this.logger.info("An error occured while starting the allocator server.");
            e.printStackTrace();
            this.server.shutdown();
        }
        this.logger.info("Genoa allocator plugin has loaded!");
    }

    private void registerServer() {
        ServerInformation info = new ServerInformation();
        info.setServerId(this.server.getServerUniqueId());
        info.setIp(this.getOutboundIp());
        info.setPort(this.server.getPort());
        try {
            String request = OBJECT_MAPPER.writeValueAsString((Object)info);
            this.client.send(request);
        }
        catch (Exception e) {
            this.logger.error("An error occured while trying to initiate the server registration.");
            e.printStackTrace();
        }
    }

    private String getOutboundIp() {
        try {
            String ip = Files.lines(Paths.get(GenoaAllocatorPlugin.get().getDataDirectory() + "/ip.txt", new String[0])).collect(Collectors.joining());
            this.logger.info("USING IP: " + ip);
            return ip;
        }
        catch (Exception e) {
            this.logger.error("Error whilst getting outbound ip!");
            e.printStackTrace();
            return null;
        }
    }

    private WebSocketClient startListeningServer() {
        String coreAddress = this.server.getConfig().getSettings().getEarthApi() + "/v1.1/private/server/ws/";
        String serverAddress = CloudServer.getInstance().getConfig().getSettings().isEnableSecureApiConnections() ? "wss://" + coreAddress : "ws://" + coreAddress;
        return new ApiClient(URI.create(serverAddress));
    }

    public void onBuildplateLoadRequest(String instanceString) {
        try {
            ServerInstanceRequestInfo instanceRequestInfo = (ServerInstanceRequestInfo)OBJECT_MAPPER.readValue(instanceString, ServerInstanceRequestInfo.class);
            this.onBuildplateLoadRequest(instanceRequestInfo);
        }
        catch (Exception e) {
            this.logger.error("An error occured while trying to load the buildplate.");
            e.printStackTrace();
        }
    }

    private void onBuildplateLoadRequest(ServerInstanceRequestInfo instance) {
        this.downloadBuildplate(instance.getBuildplateId(), instance.getPlayerId());
        BuildplateLoader.registerBuildplate((String)instance.getBuildplateId().toString());
        this.playerInstanceMap.put(instance.getPlayerId(), instance.getInstanceId());
        this.instanceBuildplateMap.put(instance.getInstanceId(), instance.getBuildplateId());
        this.markServerAsReady(instance.getInstanceId());
    }

    private void markServerAsReady(UUID instanceId) {
        ServerInstanceInfo info = new ServerInstanceInfo();
        info.setInstanceId(instanceId);
        info.setBuildplateId(this.instanceBuildplateMap.get(instanceId));
        try {
            String request = OBJECT_MAPPER.writeValueAsString((Object)info);
            GenoaUtils.SendApiCommand((GenoaServerCommand)GenoaServerCommand.MarkServerAsReady, null, (String)request);
        }
        catch (Exception e) {
            this.logger.error("Something went wrong while trying to mark the server as ready.");
            e.printStackTrace();
        }
    }

    private void downloadBuildplate(UUID buildplateId, String playerId) {
        File buildplateFile = new File(this.server.getFilePath() + "/worlds/" + buildplateId.toString() + ".json");
        if (buildplateFile.exists()) {
            return;
        }
        ServerBuildplateRequest req = new ServerBuildplateRequest();
        req.setBuildplateId(buildplateId);
        req.setPlayerId(playerId);
        try {
            String request = OBJECT_MAPPER.writeValueAsString((Object)req);
            String buildplate = GenoaUtils.SendApiCommand((GenoaServerCommand)GenoaServerCommand.GetBuildplate, null, (String)request);
            buildplateFile.createNewFile();
            FileWriter fileWriter = new FileWriter(this.server.getFilePath() + "/worlds/" + buildplateId.toString() + ".json");
            fileWriter.write(buildplate);
            fileWriter.close();
        }
        catch (IOException e) {
            this.logger.error("An error occured while downloading the buildplate!");
            e.printStackTrace();
        }
    }

    @Listener
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String playerId = player.getSkin().getSkinId().split("-")[5].toUpperCase();
        if (this.playerInstanceMap.containsKey(playerId)) {
            String buildplateId = this.instanceBuildplateMap.get(this.playerInstanceMap.get(playerId)).toString();
            Location spawnLocation = this.server.getLevel(buildplateId).getSpawnLocation();
            player.teleportImmediate(spawnLocation);
        } else {
            event.getPlayer().kick();
        }
    }

    @Listener
    public void onDisconnect(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String playerId = player.getSkin().getSkinId().split("-")[5].toUpperCase();
        if (this.playerInstanceMap.containsKey(playerId)) {
            UUID instanceId = this.playerInstanceMap.get(playerId);
            UUID buildplateId = this.instanceBuildplateMap.get(instanceId);
            this.playerInstanceMap.remove(playerId);
            this.instanceBuildplateMap.remove(instanceId);
            this.server.unloadLevel(this.server.getLevel(buildplateId.toString()));
        }
    }

    public void deleteBuildplate(UUID buildplateId) {
        File buildplateFile = new File(buildplateId.toString() + ".json");
        try {
            buildplateFile.delete();
        }
        catch (Exception e) {
            this.logger.error("An error occured while trying to delete a buildplate.");
            e.printStackTrace();
        }
    }

    public static GenoaAllocatorPlugin get() {
        return INSTANCE;
    }

    public Object getPlugin() {
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PluginDescription getDescription() {
        return this.description;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }
}

